
markup.push({

	// MARK: - base slider

	SliderView:
	{
		nsClass: "GXSliderView",
		gxIntrinsicHeight: 23,
		gxLogicalKnobSize: "21, 21",
		gxAlignmentInsets: "3, 0, 3, 0", // so thumb can glow shadow outside content - block faces miss it - no autolayout
		gxTrackPainter: "SliderTrack",
		gxKnobPainter: "SliderKnob",
		gxLabelTemplate: "LabelView.left.size13",
		gxDetentPainter: fillPainterWithSize("ForeColor2", "1, 5"),
        axRoleDescription: "Slider",
		blockFace:
		{
			gxDisableOnKey: "node.bypassed",
			gxRangeMin: 0,
			gxRangeMax: 1,
			gxFrameRect: "14,49,92,23",
			gxDetentPainter: fillPainterWithSize("ColorTheme1", "1, 5"),
		},
		smallKnob:
		{
			gxLogicalKnobSize: "16, 16",
		}
	},

	// MARK: - slider painters

	SliderTrack:
	{
		nsClass: "GXPainter",
		gxDefaultSize: "5, 5",
		gxCornerRadius: 2.5,
		gxEdgeInsets: "3, 0, 3, 0",
		gxFillColor: "BackColor3.noPressed",
		vertical: {
			gxEdgeInsets: "0, 3, 0, 3",
		},
		on: {
			gxFillColor: "ColorThemeLive1.noPressed",
		},
		blockFace:
		{
			gxFillColor: "ColorTheme2.noPressed",
			on: {
				gxFillColor: "ColorThemeLive3.noPressed",
			},
		},
//		smallKnob:
//		{
//			gxEdgeInsets: "3, 0, 3, 0",
//		},
		trackUnfilled:
		{
			// neutralize 'on'
			on: {}
		},
	},

	SliderKnob:
	{
		nsClass: "GXCirclePainter",
		gxDefaultSize: "15, 15",
        gxShadow: "{0, 0, 0, 0.75}, {0, -0.5}, 2.5",
        gxStrokeWidth: 0,

		// normal 'disabled' in BaseColor sets alpha, which doesn't look good for thumb
		gxFillColor: "ForeColorTheme1.noDisabled",
		disabled: {
			gxFillColor: "ForeColor2.noDisabled",
		},
        
        // trick: frameColor isn't going to apply until gxStrokeWidth is > 0
		gxFrameColor: "ColorThemeLive3.noPressed",
		blockFace: {
			gxFrameColor: "ColorThemeLive3.noPressed",
        },
        
		//hover: {
		//	gxStrokeWidth: 1.5,
		//	gxDefaultSize: "17, 17",
		//},
		focused: {
			gxStrokeWidth: 2.5,
			gxDefaultSize: "17, 17",
			gxShadow: "{0, 0, 0, 0.75}, {0, -0.5}, 3",
        //    gxFrameColor: "ColorThemeLive1",
            //gxShadow: "{0, 0, 0, 1}, {0, 0}, 3",
		},

		// alternate small knob for blocks
		smallKnob:
		{
			gxDefaultSize: "11, 11",
			focused: {
				gxStrokeWidth: 2.5,
				//gxDefaultSize: "16, 16",
				//gxShadow: "{0, 0, 0, 1}, {0, 0}, 3",
			},
			//hover: {
			//	gxStrokeWidth: 1.5,
			//	gxDefaultSize: "13, 13",
			//	//gxShadow: "{0, 0, 0, 1}, {0, 0}, 3",
			//},
		},
	},

	SliderDetentLabelPainter:
	{
		nsClass: "GXStringPainter",
		gxDefaultSize: "50, 40",	 	// important - wide enough for detent labels, tall enough
									// so large vertical inset can be used to position below track
		gxEdgeInsets: "0, 26, 2, 0",
		gxFontSize: 9,
		gxFontColor: "ForeColor2",
		gxAlignment: "{0.5, 1}"
	},


})
